<div class="row mini_print">
  <div class="col-sm-12">
    <table class="table table-condensed">
      <tr>
        <th><?php echo app('translator')->get('lang_v1.payment_method'); ?></th>
        <th><?php echo app('translator')->get('sale.sale'); ?></th>
        <th><?php echo app('translator')->get('lang_v1.expense'); ?></th>
      </tr>
      <tr>
        <td>
          <?php echo app('translator')->get('cash_register.cash_in_hand'); ?>:
        </td>
        <td>
          <span class="display_currency" data-currency_symbol="true"><?php echo e($register_details->cash_in_hand, false); ?></span>
        </td>
        <td>--</td>
      </tr>
      <tr>
        <td>
          <?php echo app('translator')->get('cash_register.cash_payment'); ?>:
        </th>
        <td>
          <span class="display_currency" data-currency_symbol="true"><?php echo e($register_details->total_cash, false); ?></span>
        </td>
        <td>
          <span class="display_currency" data-currency_symbol="true"><?php echo e($register_details->total_cash_expense, false); ?></span>
        </td>
      </tr>
      <!-- Removed advance_payment, cheque and other_payments -->
      <!-- Check if custom payment methods exist and do not contain restricted terms -->
      
      <?php if(array_key_exists('custom_pay_2', $payment_types) && !str_contains(strtolower($payment_types['custom_pay_2']), 'cheque') && !str_contains(strtolower($payment_types['custom_pay_2']), 'checque') && !str_contains(strtolower($payment_types['custom_pay_2']), 'credit')): ?>
        <tr>
          <td>
            <?php echo e($payment_types['custom_pay_2'], false); ?>:
          </td>
          <td>
            <span class="display_currency" data-currency_symbol="true"><?php echo e($register_details->total_custom_pay_2, false); ?></span>
          </td>
          <td>
            <span class="display_currency" data-currency_symbol="true"><?php echo e($register_details->total_custom_pay_2_expense, false); ?></span>
          </td>
        </tr>
      <?php endif; ?>
      <?php if(array_key_exists('custom_pay_3', $payment_types) && !str_contains(strtolower($payment_types['custom_pay_3']), 'cheque') && !str_contains(strtolower($payment_types['custom_pay_3']), 'checque') && !str_contains(strtolower($payment_types['custom_pay_3']), 'credit')): ?>
        <tr>
          <td>
            <?php echo e($payment_types['custom_pay_3'], false); ?>:
          </td>
          <td>
            <span class="display_currency" data-currency_symbol="true"><?php echo e($register_details->total_custom_pay_3, false); ?></span>
          </td>
          <td>
            <span class="display_currency" data-currency_symbol="true"><?php echo e($register_details->total_custom_pay_3_expense, false); ?></span>
          </td>
        </tr>
      <?php endif; ?>
      <!-- Removed custom_pay_4, custom_pay_5, custom_pay_6, custom_pay_7 -->
    </table>
    <hr>
    <table class="table table-condensed">
      <tr>
        <td>
          <?php echo app('translator')->get('cash_register.total_sales'); ?>:
        </td>
        <td>
          <span class="display_currency" data-currency_symbol="true"><?php echo e($register_details->total_sale, false); ?></span>
        </td>
      </tr>
      <tr class="danger">
        <th>
          <?php echo app('translator')->get('cash_register.total_refund'); ?>
        </th>
        <td>
          <b><span class="display_currency" data-currency_symbol="true"><?php echo e($register_details->total_refund, false); ?></span></b><br>
          <small>
          <?php if($register_details->total_cash_refund != 0): ?>
            Cash: <span class="display_currency" data-currency_symbol="true"><?php echo e($register_details->total_cash_refund, false); ?></span><br>
          <?php endif; ?>
          <!-- Removed cheque, card, bank transfer, advance refund details -->
          <!-- Check if custom payment methods exist and do not contain restricted terms for refunds -->
          <?php if(array_key_exists('custom_pay_1', $payment_types) && !str_contains(strtolower($payment_types['custom_pay_1']), 'cheque') && !str_contains(strtolower($payment_types['custom_pay_1']), 'checque') && !str_contains(strtolower($payment_types['custom_pay_1']), 'credit') && $register_details->total_custom_pay_1_refund != 0): ?>
              <?php echo e($payment_types['custom_pay_1'], false); ?>: <span class="display_currency" data-currency_symbol="true"><?php echo e($register_details->total_custom_pay_1_refund, false); ?></span>
          <?php endif; ?>
          <?php if(array_key_exists('custom_pay_2', $payment_types) && !str_contains(strtolower($payment_types['custom_pay_2']), 'cheque') && !str_contains(strtolower($payment_types['custom_pay_2']), 'checque') && !str_contains(strtolower($payment_types['custom_pay_2']), 'credit') && $register_details->total_custom_pay_2_refund != 0): ?>
              <?php echo e($payment_types['custom_pay_2'], false); ?>: <span class="display_currency" data-currency_symbol="true"><?php echo e($register_details->total_custom_pay_2_refund, false); ?></span>
          <?php endif; ?>
          <?php if(array_key_exists('custom_pay_3', $payment_types) && !str_contains(strtolower($payment_types['custom_pay_3']), 'cheque') && !str_contains(strtolower($payment_types['custom_pay_3']), 'checque') && !str_contains(strtolower($payment_types['custom_pay_3']), 'credit') && $register_details->total_custom_pay_3_refund != 0): ?>
              <?php echo e($payment_types['custom_pay_3'], false); ?>: <span class="display_currency" data-currency_symbol="true"><?php echo e($register_details->total_custom_pay_3_refund, false); ?></span>
          <?php endif; ?>
          </small>
        </td>
      </tr>
      <tr class="success">
        <th>
          <?php echo app('translator')->get('lang_v1.total_payment'); ?>
        </th>
        <td>
          <b><span class="display_currency" data-currency_symbol="true"><?php echo e($register_details->cash_in_hand + $register_details->total_cash - $register_details->total_cash_refund, false); ?></span></b>
        </td>
      </tr>
      <tr class="success">
        <th>
          <?php echo app('translator')->get('cash_register.total_sales'); ?>:
        </th>
        <td>
          <b><span class="display_currency" data-currency_symbol="true"><?php echo e($details['transaction_details']->total_sales, false); ?></span></b>
        </td>
      </tr>
      <tr class="danger">
        <th>
          <?php echo app('translator')->get('report.total_expense'); ?>:
        </th>
        <td>
          <b><span class="display_currency" data-currency_symbol="true"><?php echo e($register_details->total_expense, false); ?></span></b>
        </td>
      </tr>
    </table>
    <hr>
    <span>
        <?php echo app('translator')->get('sale.total'); ?> = 
        <?php 
            $formated_number = "";
            if (session("business.currency_symbol_placement") == "before") {
                $formated_number .= session("currency")["symbol"] . " ";
            } 
            $formated_number .= number_format((float) $register_details->cash_in_hand, session("business.currency_precision", 2) , session("currency")["decimal_separator"], session("currency")["thousand_separator"]);

            if (session("business.currency_symbol_placement") == "after") {
                $formated_number .= " " . session("currency")["symbol"];
            }
            echo $formated_number; ?> (<?php echo app('translator')->get('messages.opening'); ?>) + 
        <?php 
            $formated_number = "";
            if (session("business.currency_symbol_placement") == "before") {
                $formated_number .= session("currency")["symbol"] . " ";
            } 
            $formated_number .= number_format((float) $register_details->total_sale, session("business.currency_precision", 2) , session("currency")["decimal_separator"], session("currency")["thousand_separator"]);

            if (session("business.currency_symbol_placement") == "after") {
                $formated_number .= " " . session("currency")["symbol"];
            }
            echo $formated_number; ?> (<?php echo app('translator')->get('business.sale'); ?>) - 
        <?php 
            $formated_number = "";
            if (session("business.currency_symbol_placement") == "before") {
                $formated_number .= session("currency")["symbol"] . " ";
            } 
            $formated_number .= number_format((float) $register_details->total_refund, session("business.currency_precision", 2) , session("currency")["decimal_separator"], session("currency")["thousand_separator"]);

            if (session("business.currency_symbol_placement") == "after") {
                $formated_number .= " " . session("currency")["symbol"];
            }
            echo $formated_number; ?> (<?php echo app('translator')->get('lang_v1.refund'); ?>) - 
        <?php 
            $formated_number = "";
            if (session("business.currency_symbol_placement") == "before") {
                $formated_number .= session("currency")["symbol"] . " ";
            } 
            $formated_number .= number_format((float) $register_details->total_expense, session("business.currency_precision", 2) , session("currency")["decimal_separator"], session("currency")["thousand_separator"]);

            if (session("business.currency_symbol_placement") == "after") {
                $formated_number .= " " . session("currency")["symbol"];
            }
            echo $formated_number; ?> (<?php echo app('translator')->get('lang_v1.expense'); ?>) 
        = <?php 
            $formated_number = "";
            if (session("business.currency_symbol_placement") == "before") {
                $formated_number .= session("currency")["symbol"] . " ";
            } 
            $formated_number .= number_format((float) $register_details->cash_in_hand + $register_details->total_sale - $register_details->total_refund - $register_details->total_expense, session("business.currency_precision", 2) , session("currency")["decimal_separator"], session("currency")["thousand_separator"]);

            if (session("business.currency_symbol_placement") == "after") {
                $formated_number .= " " . session("currency")["symbol"];
            }
            echo $formated_number; ?>
    </span>
  </div>
</div>

<?php echo $__env->make('cash_register.register_product_details', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp82\htdocs\pos\resources\views/cash_register/payment_details.blade.php ENDPATH**/ ?>